**পরিকল্পনা সারসংক্ষেপ**
- আপনার `vyx` Laravel 12 প্রোজেক্টে গেম API সম্পূর্ণ (A-to-Z) ইন্টিগ্রেশন করা হবে, প্রদত্ত দুইটি PDF: `documentation of games apis.pdf` ও `credentials of games.pdf` অনুসারে।
- নিরাপদ কনফিগারেশন, রাউট, কন্ট্রোলার, সার্ভিস লেয়ার, ডাটাবেস মডেল, ট্রানজ্যাকশন, ওয়েবহুক/কলব্যাক, সিগনেচার ভেরিফিকেশন, আইডেমপোটেন্সি, লগিং ও টেস্ট—সবকিছু প্রস্তুত করা হবে।

**ইনপুট সোর্স**
- `E:\Office Project\Laravel Web Development\vyx\documentation of games apis.pdf`
- `E:\Office Project\Laravel Web Development\vyx\credentials of games.pdf`
- এগুলো থেকে: বেস URL, auth পদ্ধতি (API key/HMAC/JWT), প্রয়োজনীয় এন্ডপয়েন্ট, request/response schema, কলব্যাক স্পেসিফিকেশন, সিগনেচার/টাইমস্ট্যাম্প রুলস, ট্রানজ্যাকশন আইডি রুলস—সব বের করা হবে।

**ইন্টেগ্রেশন স্কোপ**
- প্লেয়ার সেশন তৈরি/গেম লঞ্চ
- ব্যালেন্স ফেচ, ডেবিট/ক্রেডিট, রোলব্যাক
- প্রোভাইডার কলব্যাক/ওয়েবহুক গ্রহণ ও ভেরিফাই
- ট্রানজ্যাকশন আইডেমপোটেন্সি, ডুপ্লিকেট প্রতিরোধ
- অডিট লগ, এরর হ্যান্ডলিং, রিট্রাই কৌশল

**আর্কিটেকচার**
- সার্ভিস লেয়ার: `App\Services\Games\Providers\AgulaHoccyClient` এবং `ProviderFactory`—প্রোভাইডার স্পেসিফিক লজিক আলাদা রাখা হবে।
- কন্ট্রোলার: `GameController` (প্লেয়ার-ফেসিং) ও `GameCallbackController` (ওয়েবহুক গ্রহণ)।
- মিডলওয়্যার: `ValidateProviderSignature`—প্রোভাইডার সিগনেচার/টাইমস্ট্যাম্প যাচাই।
- কনফিগ: `config/games.php`—প্রোভাইডারভিত্তিক কনফিগ ও ম্যাপিং।

**ডাটাবেস স্কিমা**
- `game_providers`: `key`, `name`, `base_url`, `merchant_id`।
- `players`: `external_id`, `status`।
- `wallets`: `player_id`, `balance`, `currency`।
- `game_sessions`: `player_id`, `provider_key`, `session_id`, `status`, `expires_at`।
- `game_transactions`: `provider_key`, `tx_id` (unique), `session_id`, `type` (debit/credit/rollback), `amount`, `currency`, `status`, `meta`, `processed_at`।
- `callback_events`: `provider_key`, `event_type`, `payload`, `signature_valid`, `handled_at`।

**কনফিগ ও এনভায়রনমেন্ট**
- `.env` কীসমূহ:
  - `GAMES_AGULA_BASE_URL`
  - `GAMES_AGULA_API_KEY`
  - `GAMES_AGULA_SECRET`
  - `GAMES_CALLBACK_BASE` (সাধারণত `APP_URL` থেকেই নেওয়া হবে)
- `config/games.php`:
  - `providers.agula-hoccy` → `{ base_url, api_key, secret, timeout }`
  - `callback.base` → `env('GAMES_CALLBACK_BASE', config('app.url'))`

**HTTP ক্লায়েন্ট ও অথ**
- Laravel `Http` ক্লায়েন্ট (Guzzle) ব্যবহার—টাইমআউট, রিট্রাই, ব্যাকঅফ কনফিগ।
- প্রোভাইডার ডকের নির্দেশনা অনুযায়ী হেডার/সিগনেচার:
  - যদি HMAC হয় → `X-Signature` = `HMAC_SHA256(secret, canonicalString)`
  - যদি JWT/Token হয় → `Authorization: Bearer <token>`
  - টাইমস্ট্যাম্প/নন্স থাকলে সাপোর্ট।

**রাউট ও এন্ডপয়েন্ট**
- `routes/api.php`:
  - `POST /api/games/{provider}/launch` → প্লেয়ার গেম লঞ্চ
  - `GET /api/games/{provider}/balance` → ব্যালেন্স
  - `POST /api/games/{provider}/debit` → ডেবিট
  - `POST /api/games/{provider}/credit` → ক্রেডিট
  - `POST /api/games/{provider}/rollback` → রোলব্যাক
  - `POST /api/games/{provider}/callback` → প্রোভাইডার কলব্যাক (ওয়েবহুক)

**কলব্যাক URL (প্রস্তুত ফরম্যাট)**
- জেনেরিক প্যাটার্ন: `<APP_URL>/api/games/{provider}/callback`
- আপনার ক্ষেত্রে (প্রোভাইডার কী `agula-hoccy` ধরে):
  - `https://<your-domain>/api/games/agula-hoccy/callback`
- প্রয়োজনে ভেন্ডর-স্পেসিফিক সাবপাথও সাপোর্ট করা হবে: `https://<your-domain>/api/games/callback/agula-hoccy`
- কলব্যাকে মিডলওয়্যার দিয়ে সিগনেচার/টাইমস্ট্যাম্প যাচাই, payload পার্স, আইডেমপোটেন্সি চেক, DB ট্রানজ্যাকশন, 200/4xx রেসপন্স।

**ট্রানজ্যাকশন ও ওয়ালেট লজিক**
- সব ফাইন্যান্সিয়াল অপারেশন DB ট্রানজ্যাকশনের ভেতরে।
- `game_transactions.tx_id` ইউনিক—একই `tx_id` রি-প্লে ব্লক।
- রোলব্যাক এন্ডপয়েন্টে পূর্বের ট্রানজ্যাকশনের স্ট্যাটাস/অমাউন্ট যাচাই।
- ব্যালেন্স আপডেট `wallets.balance`—ডেবিটে ডিডাক্ট, ক্রেডিটে অ্যাড, কনসিসটেন্সি নিশ্চিত।

**নিরাপত্তা ও রিলায়েবিলিটি**
- সিগনেচার/নন্স/টাইমস্ট্যাম্প যাচাই; ক্লক-স্কিউ টলারেন্স।
- IP allowlist (ডকে থাকলে) সাপোর্ট।
- রিট্রাই পলিসি: নেটওয়ার্ক/5xx ইরর হলে এক্সপোনেনশিয়াল ব্যাকঅফ।
- স্ট্রাকচার্ড লগিং: `storage/logs/games.log`—প্রতি রিকোয়েস্ট/রেসপন্স ট্রেস আইডি।

**টেস্টিং ও ভেরিফিকেশন**
- ফিচার টেস্ট: কলব্যাক সিগনেচার ভেরিফিকেশন, আইডেমপোটেন্সি, ব্যালেন্স আপডেট।
- কনট্র্যাক্ট টেস্ট: ডকে দেয়া উদাহরণ request/response JSON দিয়ে মক।
- Postman কালেকশন: সব এন্ডপয়েন্টের জন্য প্রস্তুত।

**ডিপ্লয়মেন্ট/কনফিগ নোটস**
- `APP_URL` সেট করে প্রোডাকশন ডোমেইন; `GAMES_*` ভ্যারিয়েবলগুলি `.env` তে সিকিউরলি।
- Queue/Jobs দরকার হলে `redis`/`database` কিউ ড্রাইভার কনফিগ।
- HTTPS বাধ্যতামূলক।

**ডেলিভারেবলস**
- নতুন কনফিগ ফাইল: `config/games.php`
- কন্ট্রোলার: `GameController`, `GameCallbackController`
- সার্ভিস: `AgulaHoccyClient`, `ProviderFactory`
- মিডলওয়্যার: `ValidateProviderSignature`
- মাইগ্রেশন/মডেল: উপরের টেবিলসমূহ
- রাউটস: `routes/api.php` তে এন্ডপয়েন্ট
- টেস্ট ও Postman কালেকশন
- প্রস্তুত কলব্যাক URL—ডোমেইন লাগলেই কপি-পেস্ট

**অ্যাকসেপটেন্স ক্রাইটেরিয়া**
- ডকের সব বাধ্যতামূলক এন্ডপয়েন্ট/ফ্লো ইমপ্লিমেন্টেড
- কলব্যাকে সিগনেচার ভেরিফাই ও আইডেমপোটেন্সি নিশ্চিত
- ব্যালেন্স/ট্রানজ্যাকশন কনসিসটেন্ট
- লগিং/এরর হ্যান্ডলিং স্পষ্ট

আপনি নিশ্চিত করলে, পরের ধাপে আমি ডক পড়ে সুনির্দিষ্ট ফিল্ড ম্যাপিং, রাউট/কন্ট্রোলার/সার্ভিস/মাইগ্রেশন কোড, `.env` কীসমূহ এবং চূড়ান্ত কলব্যাক URL গুলো ইমপ্লিমেন্ট করবো।